%{
This m-file belongs to Chapter 5 of the dissertation 'Electrochemical CO2
conversion with a flow-through copper hollow fibre'
Anne Sustronk (1,2)
(1) Films in Fluids, Department of Science and Technology, University of 
Twente, Enschede, The Netherlands
(2) Photocatalytic Synthesis Group, Department of Science and Technology, 
University of Twente, Enschede, The Netherlands

The file is used to prepare Table 5.1 in the chapter.

The next files are required to execute this file: WetDry.m and 
CalcErr_WetDry.m

Note that the file location in lines 38, 96, 103, 116, 146, 154 should be 
added before execution of this m-file

Brief overview of experimental conditions: 10 ml/min CO2 through fibre and 
20 ml/min CO2 through head space, 0.5M KHCO3, other conditions same as 
in Chapter 4

Version date m-file: April 5, 2023

%}

clear all, clc, close all

%% Size for figure

size = 6;      % Width (in cm)


%% File location and name

%% Dried Cu experiments

% Retrieve file locations
dry.Location = {'...\Data Table 5.1\Data'};
dry.Folder1 = {'\-0.8 V';'\-0.9 V';'\-1.0 V';'\-1.1 V';'\-1.2 V';'\-1.3 V';'\-1.4 V';'\-1.5 V';'\-1.6 V'};

% Retrieve file name potentiostat data
dry.FileNameEC = {'\Fiber211117-2 -0.8V CA.txt';
    '\Fiber211117-6 -0.9V CA.txt';
    '\Fiber210922-3 -1.0V CA.txt';
    '\Fiber211117-2 -1.1V CA.txt';
    '\Fiber211117-6 -1.2_03_CA_C08.txt';
    '\Fiber210922-3 -1.3V CA.txt';
    '\Fiber211117-2 -1.4V CA.txt';
    '\Fiber211117-6 -1.5V CA.txt';
    '\Fiber210922-3 -1.6V CA.txt'};

% Retrieve file name TCD data
dry.FileNameTCD = {'\Fiber211117-2 -0.8V TCD.txt';
    '\Fiber211117-6 -0.9V TCD.txt';
    '\Fiber210922-3 -1.0V TCD.txt';
    '\Fiber211117-2 -1.1V TCD.txt';
    '\Anne20211125-TCD.txt';
    '\Fiber210922-3 -1.3V TCD.txt';
    '\Fiber211117-2 -1.4V TCD.txt';
    '\Fiber211117-6 -1.5V TCD.txt';
    '\Fiber210922-3 -1.6V TCD.txt'};

% Geometric area (cm^2)
dry.Area(1,1) = 1.304*mean([0.171 0.168])*pi();
dry.Area(4,1) = dry.Area(1,1);
dry.Area(7,1) = dry.Area(1,1);

dry.Area(2,1) = 1.247*mean([0.169 0.172])*pi();
dry.Area(5,1) = dry.Area(2,1);
dry.Area(8,1) = dry.Area(2,1);

dry.Area(3,1) = 1.1*0.17*pi();
dry.Area(6,1) = dry.Area(3,1);
dry.Area(9,1) = dry.Area(3,1);

% Estimated error in geometric area (cm^2)
dry.AreaErr(1,1) = 0.1*mean([0.171 0.168])*pi();
dry.AreaErr(4,1) = dry.AreaErr(1,1);
dry.AreaErr(7,1) = dry.AreaErr(1,1);

dry.AreaErr(2,1) = 0.1*mean([0.169 0.172])*pi();
dry.AreaErr(5,1) = dry.AreaErr(2,1);
dry.AreaErr(8,1) = dry.AreaErr(2,1);

dry.AreaErr(3,1) = 0.1*0.17*pi();
dry.AreaErr(6,1) = dry.AreaErr(3,1);
dry.AreaErr(9,1) = dry.AreaErr(3,1);

% Set variable name
dry.VarName = ['Exp01'; 'Exp02'; 'Exp03'; 'Exp04';'Exp05'; 'Exp06';'Exp07'; 'Exp08';'Exp09'];

% Uncorrected potential during chronoamperometry
dry.ESet = [-0.8; -0.9;-1.0;-1.1;-1.2;-1.3;-1.4;-1.5;-1.6];

% H2 calibration Jun21
CalH2Data = importdata('...\Data Table 5.1\Matlab\H2Jun21.txt');

dry.XCalH2 = 1500;
dry.YCalH2 = CalH2Data';
dry.H2ppmErr = 54.4;

% CO calibration Jun21
CalCOData = importdata('...\Data Table 5.1\Matlab\COJun21.txt');

dry.XCalCO = 1000;
dry.YCalCO = CalCOData';
dry.COppmErr = 45;

% Call WetDry.m
dry = WetDry(dry);


%% Wet particles

% Retrieve file locations
wet.Location = {'...\Data Table 5.1\Data'};
wet.Folder1 = {'\-1.1 V ID59 sample #1';'\-1.1 V ID59 sample #2'; '\-1.1 V ID67 sample #1'};

% Retrieve file name potentiostat data
wet.FileNameEC = {'\Fiber220104-3_03_CA_C08.txt';
    '\Fiber220104-1_03_CA_C08.txt';
    '\Fiber210113-1 -1_03_CA_C08.txt'}; 

% Retrieve file name TCD data
wet.FileNameTCD = {'\Anne20211125-TCD.txt';
    '\Anne20211125-TCD.txt';
    '\Anne20201216-TCD.txt'};

% Geometric area (cm^2)
wet.Area(1,1) = 1.064*mean([0.139 0.140])*pi();
wet.Area(2,1) = 1.286*0.134*pi();
wet.Area(3,1) = 1.09*0.149*pi();

% Estimated error in geometric area (cm^2)
wet.AreaErr(1,1) = 0.1*mean([0.139 0.140])*pi();
wet.AreaErr(2,1) = 0.1*0.134*pi();
wet.AreaErr(3,1) = 0.1*0.149*pi();

% Set variable name
wet.VarName = ['Exp01'; 'Exp02'; 'Exp03'];

% Uncorrected potential during chronoamperometry
wet.ESet = [-1.1; -1.1;-1.1];

% H2 calibration Jun21
CalH2Data = importdata('...\Data Table 5.1\Matlab\H2Jun21.txt');

wet.XCalH2 = 1500;
wet.YCalH2 = CalH2Data';
wet.H2ppmErr = 54.4;


% CO calibration Jun21
CalCOData = importdata('...\Data Table 5.1\Matlab\COJun21.txt');

wet.XCalCO = 1000;
wet.YCalCO = CalCOData';
wet.COppmErr = 45;

% Call WetDry.m
wet = WetDry(wet);


%% Plot results
% The functions require the next input: (x1,y1,x2,y2, FigNum, Axis, XTick, 
% YTick, Xlabel, Ylabel, size)

PlotPCDCOAll(dry,dry,wet,wet,1,[-1.8 -0.8 -20 0], linspace(-1.8,-0.8,6),linspace(-20,0,6),'Potential vs Ag/AgCl',{'Partial current density'; '(mA cm^{-2}_{geo})'},size)
PlotPCDH2All(dry,dry,wet,wet,2,[-1.8 -0.8 -25 0], linspace(-1.8,-0.8,6),linspace(-25,0,6),'Potential vs Ag/AgCl',{'Partial current density'; '(mA cm^{-2}_{geo})'},size)

% Plot CO partial current density
function PlotPCDCOAll(x1,y1,x2,y2, FigNum, Axis, XTick, YTick, labelX, labelY, size)

fig = figure(FigNum);

hold on
for i = 1:length(x1.ESet(:,1))
    errorbar(x1.Ereal(i,1),y1.CDCO(i,1),y1.CDCO(i,2),y1.CDCO(i,2),y1.Ereal(i,2),y1.Ereal(i,2), 'ok')
end

for j = 1:length(x2.ESet)
    errorbar(x2.Ereal(j,1),y2.CDCO(j,1),y2.CDCO(j,2),y2.CDCO(j,2),y2.Ereal(j,2),y2.Ereal(j,2), 'ob')
end

hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Cambria';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis(Axis);
ax.XTick = XTick;
ax.YTick = YTick;

% X and Y label
xlabel(labelX)
ylabel(labelY)

% Figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

end

% Plot H2 partial current density
function PlotPCDH2All(x1,y1, x2,y2,FigNum, Axis, XTick, YTick, labelX, labelY, size)

fig = figure(FigNum);

hold on
for i = 1:length(x1.ESet(:,1))
    errorbar(x1.Ereal(i,1),y1.CDH2(i,1),y1.CDH2(i,2),y1.CDH2(i,2),y1.Ereal(i,2),y1.Ereal(i,2), '<k')
end

for j = 1:length(x2.ESet(:,1))
    errorbar(x2.Ereal(j,1),y2.CDH2(j,1),y2.CDH2(j,2),y2.CDH2(j,2),y2.Ereal(j,2),y2.Ereal(j,2), '<b')
end

hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Cambria';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis(Axis);
ax.XTick = XTick;
ax.YTick = YTick;

% X and Y label
xlabel(labelX)
ylabel(labelY)

% Figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

end
